# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 5
# Experiment: PMxPM, Run: 3
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A_MR5_strategy.txt
# LLM Suggested Fallback: Not Provided

def honeyed_viper(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not my_history:  # Round 1
        if "return 'C'" in opponent_program_code or "return 'c'" in opponent_program_code:
            return "D"  # Exploit always-cooperate
        if "return 'D'" in opponent_program_code or "return 'd'" in opponent_program_code:
            return "D"  # Defect against always-defect
        return "C"  # Start cooperatively
    
    current_round = len(my_history) + 1
    
    # Early game (rounds 1-3)
    if current_round <= 3:
        if "D" in opp_history:
            return "D"  # Mirror defection for rest of match
        return "C"
    
    # Mid game (rounds 4-8)
    if current_round <= 8:
        if "D" in opp_history:
            return "D"  # Unconditional defection if opponent ever defected
        if random.random() < 0.15:
            return "D"  # Small chance to test opponent
        return "C"
    
    # Late game (rounds 9-10)
    return "D"